# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _pywraplp
else:
    import _pywraplp

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



import numbers
from ortools.linear_solver.linear_solver_natural_api import OFFSET_KEY
from ortools.linear_solver.linear_solver_natural_api import inf
from ortools.linear_solver.linear_solver_natural_api import LinearExpr
from ortools.linear_solver.linear_solver_natural_api import ProductCst
from ortools.linear_solver.linear_solver_natural_api import Sum
from ortools.linear_solver.linear_solver_natural_api import SumArray
from ortools.linear_solver.linear_solver_natural_api import SumCst
from ortools.linear_solver.linear_solver_natural_api import LinearConstraint
from ortools.linear_solver.linear_solver_natural_api import VariableExpr

class Solver(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    CLP_LINEAR_PROGRAMMING = _pywraplp.Solver_CLP_LINEAR_PROGRAMMING
    GLPK_LINEAR_PROGRAMMING = _pywraplp.Solver_GLPK_LINEAR_PROGRAMMING
    GLOP_LINEAR_PROGRAMMING = _pywraplp.Solver_GLOP_LINEAR_PROGRAMMING
    SCIP_MIXED_INTEGER_PROGRAMMING = _pywraplp.Solver_SCIP_MIXED_INTEGER_PROGRAMMING
    GLPK_MIXED_INTEGER_PROGRAMMING = _pywraplp.Solver_GLPK_MIXED_INTEGER_PROGRAMMING
    CBC_MIXED_INTEGER_PROGRAMMING = _pywraplp.Solver_CBC_MIXED_INTEGER_PROGRAMMING
    GUROBI_LINEAR_PROGRAMMING = _pywraplp.Solver_GUROBI_LINEAR_PROGRAMMING
    GUROBI_MIXED_INTEGER_PROGRAMMING = _pywraplp.Solver_GUROBI_MIXED_INTEGER_PROGRAMMING
    CPLEX_LINEAR_PROGRAMMING = _pywraplp.Solver_CPLEX_LINEAR_PROGRAMMING
    CPLEX_MIXED_INTEGER_PROGRAMMING = _pywraplp.Solver_CPLEX_MIXED_INTEGER_PROGRAMMING
    XPRESS_LINEAR_PROGRAMMING = _pywraplp.Solver_XPRESS_LINEAR_PROGRAMMING
    XPRESS_MIXED_INTEGER_PROGRAMMING = _pywraplp.Solver_XPRESS_MIXED_INTEGER_PROGRAMMING
    BOP_INTEGER_PROGRAMMING = _pywraplp.Solver_BOP_INTEGER_PROGRAMMING
    SAT_INTEGER_PROGRAMMING = _pywraplp.Solver_SAT_INTEGER_PROGRAMMING

    def __init__(self, name: "std::string const &", problem_type: "operations_research::MPSolver::OptimizationProblemType"):
        _pywraplp.Solver_swiginit(self, _pywraplp.new_Solver(name, problem_type))
    __swig_destroy__ = _pywraplp.delete_Solver

    @staticmethod
    def CreateSolver(solver_id: "std::string const &") -> "operations_research::MPSolver *":
        return _pywraplp.Solver_CreateSolver(solver_id)

    @staticmethod
    def SupportsProblemType(problem_type: "operations_research::MPSolver::OptimizationProblemType") -> "bool":
        return _pywraplp.Solver_SupportsProblemType(problem_type)

    def Clear(self) -> "void":
        return _pywraplp.Solver_Clear(self)

    def NumVariables(self) -> "int":
        return _pywraplp.Solver_NumVariables(self)

    def variables(self) -> "std::vector< operations_research::MPVariable * > const &":
        return _pywraplp.Solver_variables(self)

    def variable(self, index: "int") -> "operations_research::MPVariable *":
        return _pywraplp.Solver_variable(self, index)

    def LookupVariable(self, var_name: "std::string const &") -> "operations_research::MPVariable *":
        return _pywraplp.Solver_LookupVariable(self, var_name)

    def Var(self, lb: "double", ub: "double", integer: "bool", name: "std::string const &") -> "operations_research::MPVariable *":
        return _pywraplp.Solver_Var(self, lb, ub, integer, name)

    def NumVar(self, lb: "double", ub: "double", name: "std::string const &") -> "operations_research::MPVariable *":
        return _pywraplp.Solver_NumVar(self, lb, ub, name)

    def IntVar(self, lb: "double", ub: "double", name: "std::string const &") -> "operations_research::MPVariable *":
        return _pywraplp.Solver_IntVar(self, lb, ub, name)

    def BoolVar(self, name: "std::string const &") -> "operations_research::MPVariable *":
        return _pywraplp.Solver_BoolVar(self, name)

    def NumConstraints(self) -> "int":
        return _pywraplp.Solver_NumConstraints(self)

    def constraints(self) -> "std::vector< operations_research::MPConstraint * > const &":
        return _pywraplp.Solver_constraints(self)

    def constraint(self, index: "int") -> "operations_research::MPConstraint *":
        return _pywraplp.Solver_constraint(self, index)

    def LookupConstraint(self, constraint_name: "std::string const &") -> "operations_research::MPConstraint *":
        return _pywraplp.Solver_LookupConstraint(self, constraint_name)

    def Constraint(self, *args) -> "operations_research::MPConstraint *":
        return _pywraplp.Solver_Constraint(self, *args)

    def Objective(self) -> "operations_research::MPObjective *":
        return _pywraplp.Solver_Objective(self)
    OPTIMAL = _pywraplp.Solver_OPTIMAL
    FEASIBLE = _pywraplp.Solver_FEASIBLE
    INFEASIBLE = _pywraplp.Solver_INFEASIBLE
    UNBOUNDED = _pywraplp.Solver_UNBOUNDED
    ABNORMAL = _pywraplp.Solver_ABNORMAL
    NOT_SOLVED = _pywraplp.Solver_NOT_SOLVED

    def Solve(self, *args) -> "operations_research::MPSolver::ResultStatus":
        return _pywraplp.Solver_Solve(self, *args)

    def ComputeConstraintActivities(self) -> "std::vector< double >":
        return _pywraplp.Solver_ComputeConstraintActivities(self)

    def VerifySolution(self, tolerance: "double", log_errors: "bool") -> "bool":
        return _pywraplp.Solver_VerifySolution(self, tolerance, log_errors)

    def InterruptSolve(self) -> "bool":
        return _pywraplp.Solver_InterruptSolve(self)

    def FillSolutionResponseProto(self, response: "operations_research::MPSolutionResponse *") -> "void":
        return _pywraplp.Solver_FillSolutionResponseProto(self, response)

    @staticmethod
    def SolveWithProto(model_request: "operations_research::MPModelRequest const &", response: "operations_research::MPSolutionResponse *", interrupt: "std::atomic< bool > *"=None) -> "operations_research::MPSolutionResponse *":
        return _pywraplp.Solver_SolveWithProto(model_request, response, interrupt)

    def ExportModelToProto(self, output_model: "operations_research::MPModelProto *") -> "void":
        return _pywraplp.Solver_ExportModelToProto(self, output_model)

    def SetSolverSpecificParametersAsString(self, parameters: "std::string const &") -> "bool":
        return _pywraplp.Solver_SetSolverSpecificParametersAsString(self, parameters)
    FREE = _pywraplp.Solver_FREE
    AT_LOWER_BOUND = _pywraplp.Solver_AT_LOWER_BOUND
    AT_UPPER_BOUND = _pywraplp.Solver_AT_UPPER_BOUND
    FIXED_VALUE = _pywraplp.Solver_FIXED_VALUE
    BASIC = _pywraplp.Solver_BASIC

    @staticmethod
    def infinity() -> "double":
        return _pywraplp.Solver_infinity()

    def EnableOutput(self) -> "void":
        return _pywraplp.Solver_EnableOutput(self)

    def SuppressOutput(self) -> "void":
        return _pywraplp.Solver_SuppressOutput(self)

    def iterations(self) -> "int64_t":
        return _pywraplp.Solver_iterations(self)

    def nodes(self) -> "int64_t":
        return _pywraplp.Solver_nodes(self)

    def ComputeExactConditionNumber(self) -> "double":
        return _pywraplp.Solver_ComputeExactConditionNumber(self)

    def NextSolution(self) -> "bool":
        return _pywraplp.Solver_NextSolution(self)

    def set_time_limit(self, time_limit_milliseconds: "int64_t") -> "void":
        return _pywraplp.Solver_set_time_limit(self, time_limit_milliseconds)

    def wall_time(self) -> "int64_t":
        return _pywraplp.Solver_wall_time(self)

    def LoadModelFromProto(self, input_model: "operations_research::MPModelProto const &") -> "std::string":
        return _pywraplp.Solver_LoadModelFromProto(self, input_model)

    def LoadModelFromProtoWithUniqueNamesOrDie(self, input_model: "operations_research::MPModelProto const &") -> "std::string":
        return _pywraplp.Solver_LoadModelFromProtoWithUniqueNamesOrDie(self, input_model)

    def LoadSolutionFromProto(self, *args) -> "bool":
        return _pywraplp.Solver_LoadSolutionFromProto(self, *args)

    def ExportModelAsLpFormat(self, obfuscated: "bool") -> "std::string":
        return _pywraplp.Solver_ExportModelAsLpFormat(self, obfuscated)

    def ExportModelAsMpsFormat(self, fixed_format: "bool", obfuscated: "bool") -> "std::string":
        return _pywraplp.Solver_ExportModelAsMpsFormat(self, fixed_format, obfuscated)

    def SetHint(self, variables: "std::vector< operations_research::MPVariable * > const &", values: "std::vector< double > const &") -> "void":
        return _pywraplp.Solver_SetHint(self, variables, values)

    def SetNumThreads(self, num_theads: "int") -> "bool":
        return _pywraplp.Solver_SetNumThreads(self, num_theads)

    def Add(self, constraint, name=''):
      if isinstance(constraint, bool):
        if constraint:
          return self.RowConstraint(0, 0, name)
        else:
          return self.RowConstraint(1, 1, name)
      else:
        return constraint.Extract(self, name)

    def Sum(self, expr_array):
      result = SumArray(expr_array)
      return result

    def RowConstraint(self, *args):
      return self.Constraint(*args)

    def Minimize(self, expr):
      objective = self.Objective()
      objective.Clear()
      objective.SetMinimization()
      if isinstance(expr, numbers.Number):
          objective.SetOffset(expr)
      else:
          coeffs = expr.GetCoeffs()
          objective.SetOffset(coeffs.pop(OFFSET_KEY, 0.0))
          for v, c, in list(coeffs.items()):
            objective.SetCoefficient(v, float(c))

    def Maximize(self, expr):
      objective = self.Objective()
      objective.Clear()
      objective.SetMaximization()
      if isinstance(expr, numbers.Number):
          objective.SetOffset(expr)
      else:
          coeffs = expr.GetCoeffs()
          objective.SetOffset(coeffs.pop(OFFSET_KEY, 0.0))
          for v, c, in list(coeffs.items()):
            objective.SetCoefficient(v, float(c))


    @staticmethod
    def Infinity() -> "double":
        return _pywraplp.Solver_Infinity()

    def SetTimeLimit(self, x: "int64_t") -> "void":
        return _pywraplp.Solver_SetTimeLimit(self, x)

    def WallTime(self) -> "int64_t":
        return _pywraplp.Solver_WallTime(self)

    def Iterations(self) -> "int64_t":
        return _pywraplp.Solver_Iterations(self)

# Register Solver in _pywraplp:
_pywraplp.Solver_swigregister(Solver)

def Solver_CreateSolver(solver_id: "std::string const &") -> "operations_research::MPSolver *":
    return _pywraplp.Solver_CreateSolver(solver_id)

def Solver_SupportsProblemType(problem_type: "operations_research::MPSolver::OptimizationProblemType") -> "bool":
    return _pywraplp.Solver_SupportsProblemType(problem_type)

def Solver_SolveWithProto(model_request: "operations_research::MPModelRequest const &", response: "operations_research::MPSolutionResponse *", interrupt: "std::atomic< bool > *"=None) -> "operations_research::MPSolutionResponse *":
    return _pywraplp.Solver_SolveWithProto(model_request, response, interrupt)

def Solver_infinity() -> "double":
    return _pywraplp.Solver_infinity()

def Solver_Infinity() -> "double":
    return _pywraplp.Solver_Infinity()


def __lshift__(*args) -> "std::ostream &":
    return _pywraplp.__lshift__(*args)
class Objective(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Clear(self) -> "void":
        return _pywraplp.Objective_Clear(self)

    def SetCoefficient(self, var: "Variable", coeff: "double") -> "void":
        return _pywraplp.Objective_SetCoefficient(self, var, coeff)

    def GetCoefficient(self, var: "Variable") -> "double":
        return _pywraplp.Objective_GetCoefficient(self, var)

    def SetOffset(self, value: "double") -> "void":
        return _pywraplp.Objective_SetOffset(self, value)

    def offset(self) -> "double":
        return _pywraplp.Objective_offset(self)

    def SetOptimizationDirection(self, maximize: "bool") -> "void":
        return _pywraplp.Objective_SetOptimizationDirection(self, maximize)

    def SetMinimization(self) -> "void":
        return _pywraplp.Objective_SetMinimization(self)

    def SetMaximization(self) -> "void":
        return _pywraplp.Objective_SetMaximization(self)

    def maximization(self) -> "bool":
        return _pywraplp.Objective_maximization(self)

    def minimization(self) -> "bool":
        return _pywraplp.Objective_minimization(self)

    def Value(self) -> "double":
        return _pywraplp.Objective_Value(self)

    def BestBound(self) -> "double":
        return _pywraplp.Objective_BestBound(self)

    def Offset(self) -> "double":
        return _pywraplp.Objective_Offset(self)
    __swig_destroy__ = _pywraplp.delete_Objective

# Register Objective in _pywraplp:
_pywraplp.Objective_swigregister(Objective)

class Variable(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    def name(self) -> "std::string const &":
        return _pywraplp.Variable_name(self)

    def SetInteger(self, integer: "bool") -> "void":
        return _pywraplp.Variable_SetInteger(self, integer)

    def integer(self) -> "bool":
        return _pywraplp.Variable_integer(self)

    def solution_value(self) -> "double":
        return _pywraplp.Variable_solution_value(self)

    def index(self) -> "int":
        return _pywraplp.Variable_index(self)

    def lb(self) -> "double":
        return _pywraplp.Variable_lb(self)

    def ub(self) -> "double":
        return _pywraplp.Variable_ub(self)

    def SetBounds(self, lb: "double", ub: "double") -> "void":
        return _pywraplp.Variable_SetBounds(self, lb, ub)

    def reduced_cost(self) -> "double":
        return _pywraplp.Variable_reduced_cost(self)

    def basis_status(self) -> "operations_research::MPSolver::BasisStatus":
        return _pywraplp.Variable_basis_status(self)

    def branching_priority(self) -> "int":
        return _pywraplp.Variable_branching_priority(self)

    def SetBranchingPriority(self, priority: "int") -> "void":
        return _pywraplp.Variable_SetBranchingPriority(self, priority)

    def __str__(self) -> "std::string":
        return _pywraplp.Variable___str__(self)

    def __repr__(self) -> "std::string":
        return _pywraplp.Variable___repr__(self)

    def __getattr__(self, name):
      return getattr(VariableExpr(self), name)


    def SolutionValue(self) -> "double":
        return _pywraplp.Variable_SolutionValue(self)

    def Integer(self) -> "bool":
        return _pywraplp.Variable_Integer(self)

    def Lb(self) -> "double":
        return _pywraplp.Variable_Lb(self)

    def Ub(self) -> "double":
        return _pywraplp.Variable_Ub(self)

    def SetLb(self, x: "double") -> "void":
        return _pywraplp.Variable_SetLb(self, x)

    def SetUb(self, x: "double") -> "void":
        return _pywraplp.Variable_SetUb(self, x)

    def ReducedCost(self) -> "double":
        return _pywraplp.Variable_ReducedCost(self)
    __swig_destroy__ = _pywraplp.delete_Variable

# Register Variable in _pywraplp:
_pywraplp.Variable_swigregister(Variable)

class Constraint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def name(self) -> "std::string const &":
        return _pywraplp.Constraint_name(self)

    def Clear(self) -> "void":
        return _pywraplp.Constraint_Clear(self)

    def SetCoefficient(self, var: "Variable", coeff: "double") -> "void":
        return _pywraplp.Constraint_SetCoefficient(self, var, coeff)

    def GetCoefficient(self, var: "Variable") -> "double":
        return _pywraplp.Constraint_GetCoefficient(self, var)

    def lb(self) -> "double":
        return _pywraplp.Constraint_lb(self)

    def ub(self) -> "double":
        return _pywraplp.Constraint_ub(self)

    def SetBounds(self, lb: "double", ub: "double") -> "void":
        return _pywraplp.Constraint_SetBounds(self, lb, ub)

    def set_is_lazy(self, laziness: "bool") -> "void":
        return _pywraplp.Constraint_set_is_lazy(self, laziness)

    def index(self) -> "int":
        return _pywraplp.Constraint_index(self)

    def dual_value(self) -> "double":
        return _pywraplp.Constraint_dual_value(self)

    def basis_status(self) -> "operations_research::MPSolver::BasisStatus":
        return _pywraplp.Constraint_basis_status(self)

    def Lb(self) -> "double":
        return _pywraplp.Constraint_Lb(self)

    def Ub(self) -> "double":
        return _pywraplp.Constraint_Ub(self)

    def SetLb(self, x: "double") -> "void":
        return _pywraplp.Constraint_SetLb(self, x)

    def SetUb(self, x: "double") -> "void":
        return _pywraplp.Constraint_SetUb(self, x)

    def DualValue(self) -> "double":
        return _pywraplp.Constraint_DualValue(self)
    __swig_destroy__ = _pywraplp.delete_Constraint

# Register Constraint in _pywraplp:
_pywraplp.Constraint_swigregister(Constraint)

class MPSolverParameters(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    RELATIVE_MIP_GAP = _pywraplp.MPSolverParameters_RELATIVE_MIP_GAP
    PRIMAL_TOLERANCE = _pywraplp.MPSolverParameters_PRIMAL_TOLERANCE
    DUAL_TOLERANCE = _pywraplp.MPSolverParameters_DUAL_TOLERANCE
    PRESOLVE = _pywraplp.MPSolverParameters_PRESOLVE
    LP_ALGORITHM = _pywraplp.MPSolverParameters_LP_ALGORITHM
    INCREMENTALITY = _pywraplp.MPSolverParameters_INCREMENTALITY
    SCALING = _pywraplp.MPSolverParameters_SCALING
    PRESOLVE_OFF = _pywraplp.MPSolverParameters_PRESOLVE_OFF
    PRESOLVE_ON = _pywraplp.MPSolverParameters_PRESOLVE_ON
    DUAL = _pywraplp.MPSolverParameters_DUAL
    PRIMAL = _pywraplp.MPSolverParameters_PRIMAL
    BARRIER = _pywraplp.MPSolverParameters_BARRIER
    INCREMENTALITY_OFF = _pywraplp.MPSolverParameters_INCREMENTALITY_OFF
    INCREMENTALITY_ON = _pywraplp.MPSolverParameters_INCREMENTALITY_ON
    SCALING_OFF = _pywraplp.MPSolverParameters_SCALING_OFF
    SCALING_ON = _pywraplp.MPSolverParameters_SCALING_ON

    def __init__(self):
        _pywraplp.MPSolverParameters_swiginit(self, _pywraplp.new_MPSolverParameters())

    def SetDoubleParam(self, param: "operations_research::MPSolverParameters::DoubleParam", value: "double") -> "void":
        return _pywraplp.MPSolverParameters_SetDoubleParam(self, param, value)

    def SetIntegerParam(self, param: "operations_research::MPSolverParameters::IntegerParam", value: "int") -> "void":
        return _pywraplp.MPSolverParameters_SetIntegerParam(self, param, value)

    def GetDoubleParam(self, param: "operations_research::MPSolverParameters::DoubleParam") -> "double":
        return _pywraplp.MPSolverParameters_GetDoubleParam(self, param)

    def GetIntegerParam(self, param: "operations_research::MPSolverParameters::IntegerParam") -> "int":
        return _pywraplp.MPSolverParameters_GetIntegerParam(self, param)
    __swig_destroy__ = _pywraplp.delete_MPSolverParameters

# Register MPSolverParameters in _pywraplp:
_pywraplp.MPSolverParameters_swigregister(MPSolverParameters)
cvar = _pywraplp.cvar
MPSolverParameters.kDefaultRelativeMipGap = _pywraplp.cvar.MPSolverParameters_kDefaultRelativeMipGap
MPSolverParameters.kDefaultPrimalTolerance = _pywraplp.cvar.MPSolverParameters_kDefaultPrimalTolerance
MPSolverParameters.kDefaultDualTolerance = _pywraplp.cvar.MPSolverParameters_kDefaultDualTolerance
MPSolverParameters.kDefaultPresolve = _pywraplp.cvar.MPSolverParameters_kDefaultPresolve
MPSolverParameters.kDefaultIncrementality = _pywraplp.cvar.MPSolverParameters_kDefaultIncrementality

class ModelExportOptions(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _pywraplp.ModelExportOptions_swiginit(self, _pywraplp.new_ModelExportOptions())
    __swig_destroy__ = _pywraplp.delete_ModelExportOptions

# Register ModelExportOptions in _pywraplp:
_pywraplp.ModelExportOptions_swigregister(ModelExportOptions)


def ExportModelAsLpFormat(*args) -> "std::string":
    return _pywraplp.ExportModelAsLpFormat(*args)

def ExportModelAsMpsFormat(*args) -> "std::string":
    return _pywraplp.ExportModelAsMpsFormat(*args)

def FindErrorInModelProto(input_model: "operations_research::MPModelProto const &") -> "std::string":
    return _pywraplp.FindErrorInModelProto(input_model)

def setup_variable_operator(opname):
  setattr(Variable, opname,
          lambda self, *args: getattr(VariableExpr(self), opname)(*args))
for opname in LinearExpr.OVERRIDDEN_OPERATOR_METHODS:
  setup_variable_operator(opname)



